using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;

using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmReportBloodAvailability
	/// </summary>
	public class FrmReportBloodAvailability : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private gov.va.med.vbecs.GUI.controls.PatientSelectTool patientSelectTool1;
		private System.Windows.Forms.Button btnCancelPatient;
		private System.ComponentModel.IContainer components = null;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmReportBloodAvailability()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();
		}

		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.patientSelectTool1 = new gov.va.med.vbecs.GUI.controls.PatientSelectTool();
			this.btnCancelPatient = new System.Windows.Forms.Button();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(664, 30);
			this.vbecsLogo1.TabIndex = 3;
			this.vbecsLogo1.Title = "Patient Search";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 4;
			// 
			// patientSelectTool1
			// 
			this.patientSelectTool1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.patientSelectTool1.DisplaySIAndTRs = true;
			this.patientSelectTool1.EnabledBloodAvailButton = false;
			this.patientSelectTool1.EnabledMedicationButton = false;
			this.patientSelectTool1.EnabledRecentOrdersButton = false;
			this.patientSelectTool1.EnabledRecentTransfusionsIssuesButton = false;
			this.patientSelectTool1.EnabledSIAndTRButton = false;
			this.patientSelectTool1.EnabledTransfusionReactionHistoryButton = false;
			this.patientSelectTool1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.patientSelectTool1.Location = new System.Drawing.Point(4, 32);
			this.patientSelectTool1.Name = "patientSelectTool1";
			this.patientSelectTool1.SearchVistaLink = false;
			this.patientSelectTool1.Size = new System.Drawing.Size(654, 408);
			this.patientSelectTool1.TabIndex = 0;
			this.patientSelectTool1.DoubleClick += new System.EventHandler(this.patientSelectTool1_DoubleClick);
			this.patientSelectTool1.PatientSelected += new System.EventHandler(this.patientSelectTool1_PatientSelected);
			this.patientSelectTool1.PatientDeselected += new System.EventHandler(this.patientSelectTool1_PatientDeselected);
			// 
			// btnCancelPatient
			// 
			this.btnCancelPatient.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancelPatient.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancelPatient.Location = new System.Drawing.Point(584, 444);
			this.btnCancelPatient.Name = "btnCancelPatient";
			this.btnCancelPatient.TabIndex = 2;
			this.btnCancelPatient.Text = "&Cancel";
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(504, 444);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 1;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// FrmReportBloodAvailability
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancelPatient;
			this.ClientSize = new System.Drawing.Size(664, 473);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancelPatient);
			this.Controls.Add(this.patientSelectTool1);
			this.hlphelpChm.SetHelpKeyword(this, "Blood_Availability.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(672, 450);
			this.Name = "FrmReportBloodAvailability";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Patient Search";
			this.Controls.SetChildIndex(this.patientSelectTool1, 0);
			this.Controls.SetChildIndex(this.btnCancelPatient, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.ResumeLayout(false);

		}
		#endregion

		private void patientSelectTool1_PatientSelected(object sender, System.EventArgs e)
		{
			btnOK.EnabledButton = true;
		}

		private void patientSelectTool1_PatientDeselected(object sender, System.EventArgs e)
		{
			btnOK.EnabledButton = false;
		}
		private void patientSelectTool1_DoubleClick(object sender, System.EventArgs e)
		{
			this.btnOK_Click(sender, e);
		}

		/// <summary>
		/// Get Patient
		/// </summary>
		public BOL.Patient Patient
		{
			get
			{
				return (BOL.Patient)patientSelectTool1.SelectedPatient.Clone();
			}
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			BOL.BloodAvailability ba = new BOL.BloodAvailability();
			ba.IsMultiDivisional = false;
			ba.IsIndividualPatientReport = true;
			ba.PatientGuid = this.Patient.PatientGuid;
					
			//Find the number of blood units for selected patient.
			int count=ba.GetBloodAvailabilityCount();

			//If there are no blood units, alert user
			if(count==0)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.NoInfoReturned());
				return;
			}
				//If there are more than 50 pages, alert user
			else if((count/25)>=50)
			{
				DialogResult _result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC049.PageCountAlert());
				//User chooses not to go through with the report construction
				if(_result != DialogResult.Yes)
					return;
					//User decides to show report
				else
				{
					//Alert user that building report may take a few minutes
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.Warning());
				}
			}
			this.DialogResult = DialogResult.OK;
			this.Close();
		}
	}
}

